<?php

namespace App\Http\Controllers\Admin;

use App\Models\People;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Image;

class PeopleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.people.index');
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.people.create');
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->hasFile('image')){
                if($request->people_type=="client"){

                    $client_logo=$request->image->store('posts'); 
                    $image=Image::make(public_path("storage/{$client_logo}"))->fit(66,66);
                    $image->save();

                    People::create([
                        "people_type" => $request->people_type,
                      "name" => $request->name,
                      "post" => $request->post,
                        "description" => $request->description,
                      "status" => $request->status,
                       "image" => $client_logo,
                       "weight" => $request->weight
                      ]);  
                }
                if($request->people_type=="worker"){

                    $worker_logo=$request->image->store('posts'); 
                    $image=Image::make(public_path("storage/{$worker_logo}"))->fit(510,500);
                    $image->save();


                    People::create([
                        "people_type" => $request->people_type,
                      "name" => $request->name,
                      "post" => $request->post,
                        "description" => $request->description,
                      "status" => $request->status,
                       "image" => $worker_logo,
                       "weight" => $request->weight
                      ]);  
        

                }
        

                       }else{

                        People::create([
                            "people_type" => $request->people_type,
                          "name" => $request->name,
                          "post" => $request->post,
                            "description" => $request->description,
                          "status" => $request->status,
                           "image" => null,
                           "weight" => $request->weight
                          ]);  

                       }
                       session()->flash('success','People information sucesfully added');
                       return redirect(route('people.index'));
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $people=People::find($id);
        return view('admin.people.edit',compact('people'));
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $people=People::findorfail($id);
        $data=$request->only(['people_type','name','post','description','weight','status']);
        if($request->hasFile('image')){ 

            if($request->people_type=="worker"){
                
                $logo=$request->image->store('posts'); 
                $image=Image::make(public_path("storage/{$logo}"))->fit(510,500);
                $image->save();

                Storage::delete($people->image);
                $data['image'] = $logo;
          
            }
            if($request->people_type=="client"){
                $logo=$request->image->store('posts'); 
                $image=Image::make(public_path("storage/{$logo}"))->fit(66,66);
                $image->save();


                Storage::delete($people->image);
                $data['image'] = $logo;
    
            }

          

           
        }

        $people->update($data);
        session()->flash('success','People information sucesfully updated');
        return redirect(route('people.index'));
        //
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        $people=People::findorfail($id);
        $people->delete();
        session()->flash('error','People information  sucesfully deleted');
        return redirect(route('people.index'));
        //
    }


    public function status($id){
      
        $people=People::find($id);  
        if($people->status== 1){
            $people->status = 0;
        }else{
            $people->status =1;
        }
        session()->flash('success','Status has been succesfully changed');
        $people->save();
            return redirect(route('people.index'));
      }

}
